﻿using System;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace PWS.API.Window.Sample7
{
    public partial class FormMain : Form
    {
        [DllImport("user32.dll")]
        public static extern bool AnimateWindow(IntPtr hwnd, int dwTime, AnimateWindowFlags dwFlags);

        [Flags]
        public enum AnimateWindowFlags : long
        {
            AW_HOR_POSITIVE = 0x1,
            AW_HOR_NEGATIVE = 0x2,
            AW_VER_POSITIVE = 0x4,
            AW_VER_NEGATIVE = 0x8,
            AW_CENTER = 0x10,
            AW_HIDE = 0x10000,
            AW_ACTIVATE = 0x20000,
            AW_SLIDE = 0x40000,
            AW_BLEND = 0x80000
        }

        public FormMain()
        {
            InitializeComponent();
        }

        private void buttonAnimate1_Click(object sender, EventArgs e)
        {
            AnimateWindow(textBoxAnimate.Handle, 5000, AnimateWindowFlags.AW_HOR_POSITIVE);
        }

        private void buttonAnimate2_Click(object sender, EventArgs e)
        {
            AnimateWindow(textBoxAnimate.Handle, 5000, AnimateWindowFlags.AW_HOR_POSITIVE | AnimateWindowFlags.AW_HIDE);
        }

        private void FormMain_Load(object sender, EventArgs e)
        {
            AnimateWindow(this.Handle, 5000, AnimateWindowFlags.AW_CENTER);
            AnimateWindow(this.Handle, 5000, AnimateWindowFlags.AW_VER_POSITIVE | AnimateWindowFlags.AW_HOR_NEGATIVE);
        }
    }
}